/**ControlP5 Textfield Andreas Schlegel,
 www.sojamo.de/libraries/controlp5 */

import controlP5.*; // Importer la librairie Control p5
ControlP5 cp5; 

String textValue = ""; //instanciation de la var textvalue de type string

Accordion accordion; // liste de ControlGroup. 

int c = color(100); // Définie la couleur c. 

PFont f; // Déclare la font, localisée dans le dossier data



void setup() {
  size(1550, 800); //Taille de la zone d'affichage

  /*// Code pour voir les fonts disponibles dans le système : 
   String[] fontList = PFont.list();
   printArray(fontList);*/

  PFont font = createFont("Braile Font", 40); 

  cp5 = new ControlP5(this); //Instanciation du ControlP5
  
  // Groupe numéro 1 (g1):   // Création du groupe de controllers "g1", permet de regrouper les controllers
  //Group g1 = cp5.addGroup("Menu1");
    //g1.setBackgroundColor(color(255, 50));
    //g1.setBackgroundHeight(250);
    
  GroupCp5 group1 = new GroupCp5(cp5, "Menu1",250);
  GroupCp5 group2 = new GroupCp5(cp5, "Menu2",250);
  GroupCp5 group3 = new GroupCp5(cp5, "Menu3",150);
  
  cp5.addTextfield("textValue")  /* Création du controller TextField ( utiliser les flèches haut bas permet de naviguer dans l'historique de TextField */
    .setLabel("Entrez Le Texte") //Méthodes créées à partir du controller P5 Textfield
    .setPosition(25, 70)
    .setSize(200, 40)
    .setFont(createFont("OratorStd", 20)) 
    .setAutoClear(false)         // Permet de garder le texte affiché dans la zone d'affichage
    .setGroup(group1.getGroup())                // Relier le controller au groupe g1.
    ;  



  cp5.addBang("clear")  //Ajouter un Bang, un controller qui déclenche un évenement ( clear) lorsqu'il est cliqué. 
    .setPosition(145, 150)
    .setSize(80, 40)
    .setGroup(group1.getGroup())
    .getCaptionLabel() 
    .align(ControlP5.CENTER, ControlP5.CENTER)
    ;    

  textFont(font); //Attribue la font de la variable "font" à textFont

  //Roue des couleurs 
  cp5.addColorWheel("c")
    .setRGB(color(19, 215, 219 )) //couleur affichée à l'allumage 
    .setPosition(25, 20) 
    .setGroup(group2.getGroup())
    ;
    
  cp5.getController("c")
  .setLabelVisible(false); //Effacer les indications de titres etc.. 

  // ajouter le slider
  cp5.addSlider("FontSize")
    .setPosition(25, 50)
    .setSize(200, 40)
    .setRange(0, 100)
    .setValue(0)
    .setLabel("")
    .setGroup(group3.getGroup())
    ;
 
  /*Créer l'accordéon qui permet de replier le menu 
   Ajouter g1, g2 et g3 à l'accordéon */
       accordion = cp5.addAccordion("acc") //instancier l'accordion
    .setPosition(40, 40)
    .setWidth(250)
    .addItem(group1.getGroup())
    .addItem(group2.getGroup())
    .addItem(group3.getGroup());
     accordion.open(0, 1, 2); // Garder ouvert les groupes du menu ( 3 "boîtes ")
  accordion.setCollapseMode(Accordion.MULTI); // Autorise le menu à ouvrir plusieurs groupes en même temps
    
}

void draw() {
  background(25);
  fill(c);
  text(textValue, 400, height * 0.5); //Mettre le texte à 400 px et milieu de la hauteur. 
}

//Pour effeg2
public void clear() {
  cp5.get(Textfield.class, "textValue").clear();
} 

void mouseReleased(){ //Fonction mouseReleased appelée lorsque mouse relachée
if (cp5.getMouseOverList().size() > 0){ // Si ma souris est au dessus d'un élément ( mais comprend groupe et controller ) 
  if(cp5.getMouseOverList().get(0) instanceof Slider){ //boucle 2 : et qu'il est un slider
    println("MOUSE RELEASED"); //Print dans la console.. 
    textSize(cp5.getMouseOverList().get(0).getValue()); //.. sa valeur 
      }
      }

}

void controlEvent(ControlEvent e){ //Pour récupérer sa valeur dans la console : L'évenement e 
  if(e.getName() == "FontSize"){   //qui s'appelle FontSize,
    println("CONTROL EVENT");      //Récupère sa valeur
      println(e.getController().getValue()); 
    } }
    
    
    //Fin du code

    